%% This Program correct the scanline shift and XY shift. 
clear,clc;
ioo = 2; % 1--ݣ2--
tris = 0; % scanline shift size
peakAS = 40;

packDir = fileparts(pwd);
tpDir = [packDir '\TP image'];
tpPack = dir(tpDir);
if ioo == 1
    fileTP = [tpDir '\' tpPack(3).name '\' tpPack(3).name '_Cycle00001_CurrentSettings_Ch2_'];
else
    fileTP = [tpDir '\' tpPack(3).name '\' tpPack(3).name '_Cycle00001_Ch2_'];
end
NumFrame = size(dir([tpDir '\' tpPack(3).name]),1) - 6;

NBlk = 100; %ÿ256ļһ
    
% sumIm=zeros(512,512);
% disp('Generating reference image ... ...');
% for i=6000:7000
%     disp(['Generating reference image ... ... # ' int2str(i)]);
%     imN=num2str(i+1000000);
%     if ioo == 1
%         imfileName=[fileTP imN(2:7) '.tif'];
%     else
%         imfileName=[fileTP imN(2:7) '.ome.tif'];
%     end
%     imX=imread(imfileName);
%     imY=sumIm;
%     sumIm(:,:)=double(imX)+double(imY(:,:));
% end 
% if tris>=0
%     BsIm = sumIm/1000;
%     AsIm = zeros(512); AsIm(2:2:512,:) = BsIm(2:2:512,:);
%     AsIm(1:2:512,1+tris:512) = BsIm(1:2:512, 1:512-tris);       
% else
%     BsIm = sumIm/1000;
%     AsIm = zeros(512); AsIm(2:2:512,:) = BsIm(2:2:512,:);
%     AsIm(1:2:512,1:512-abs(tris)) = BsIm(1:2:512, 1+abs(tris):512);      
% end
% imY1=AsIm;  
% 
% figure(2);
% imshow(imY1/2000); 
% pause;
% %load imY1 imY1;
% save imY1 imY1;

load imY1 imY1;

NTS = floor(NumFrame/NBlk);
SumAllFrameXYCorr = zeros(512,512,NBlk);

imYB1 = zeros(512,512,NBlk);
for fi=1:NBlk
    imYB1(:,:,fi) = imY1;
end

tic;
poolobj = parpool(4);
for si=1:NTS
    disp(['Maximum value for si -- ' int2str(floor(NumFrame/NBlk)) ' ... ... This step : si = ' int2str(si)]);
    parfor fi=1:NBlk
        i = (si-1)*NBlk+fi;
        imN=num2str(i+1000000);
        if ioo == 1
            imfileName=[fileTP imN(2:7) '.tif'];
        else
            imfileName=[fileTP imN(2:7) '.ome.tif'];
        end
        imX=imread(imfileName);
        imY2=double(imX);
        pA=zeros(512,512,2);
        pA(:,:,1)=imYB1(:,:,fi);
        pA(:,:,2)=imY2;
        
        % shift correction
        WIDTH = size(pA,1);
        HEIGHT = size(pA,2);
        margeSize=40;
        pA(WIDTH+1:WIDTH+margeSize*2,HEIGHT+1:HEIGHT+margeSize*2,:) = 0;
        pA(margeSize+1:WIDTH+margeSize,margeSize+1:HEIGHT+margeSize,:)=pA(1:WIDTH,1:HEIGHT,:);
       
        pbase = pA(:,:,1);
        pinput = pA(:,:,2);
        
        Side = 100;
        x1=Side+margeSize+1;
        x2=WIDTH+margeSize-Side;
        y1=Side+margeSize+1;
        y2=WIDTH+margeSize-Side;        
        s1 = pinput(y1:y2,x1:x2);
        c = normxcorr2(s1,pbase);
        [max_c, imax] = max(abs(c(:)));
        [ypeak, xpeak] = ind2sub(size(c),imax(1));

        xbias = xpeak-(size(s1,2)+size(pbase,2))/2;
        ybias = ypeak-(size(s1,1)+size(pbase,1))/2;

        if abs(xbias)>margeSize || abs(ybias)>margeSize
            disp('exception: exceed margeSize!');
            xbias = 0;
            ybias = 0;
        end                                

        imY3=zeros(512,512);
        imY3=pinput((margeSize+1:WIDTH+margeSize)-ybias,(margeSize+1:HEIGHT+margeSize)-xbias);

        imwrite(imY3/8192/2,[packDir '\Corr\' num2str((si-1)*NBlk+fi)],'JPEG', 'BitDepth',12)
        imY=SumAllFrameXYCorr(:,:,fi);
        SumAllFrameXYCorr(:,:,fi) = double(imY)+double(imY3);
    end
end
delete(poolobj);% delete(gcp);
toc;
% % For checking
% NumFrame =300000;
% sumIm = zeros(512,512);
% for i = 1:100:floor(NumFrame/100)*100
%     imfileName=[packDir '\Corr\' num2str(i)];
%     imX=imread(imfileName);
%     sumIm = sumIm + double(imX);
%     imshow(imX*100)
%     disp(int2str(i));
%     pause(0.1);
% end
% imshow(sumIm/100000);
% imwrite(sumIm/100000, '1026_sumIm.jpg', 'Quality', 100);
% 
% targetArea = sumIm(48:357, 41:350)/500000;
% targetArea(295:300, 300-100/800*512:300) = 65535;
% imshow(targetArea)
% 
% imwrite(targetArea, 'targetLayer-525-25-visualStim.tif');
